////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBImage.h
//      Definition of OBImage class. Class is cross-platform handling an image. This is for class for use with obsolete drawing.
//
//  Copyright: (C) 2010 MYOB US, Inc., all rights reserved.
//
//  Change History (most recent first): 
//
//  10/10/10  K.L.S.  Created File.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CrossPlatform/CrossPlatform.h"

class EXTERNAL_API OBImage : public CPObject
{
public:
	static CPString ImageNameFollowLinkFreestandingTemplate(void);
	static OBImage ImageNamed(const CPString& ImageName);
	static OBImage ImageWithContentsOfFile(const CPString& Path);
	static OBImage ImageWithData(const CPData& ImageData);
	static OBImage ImageWithDIBData(const CPData& DIBData);

	OBImage(void);
	virtual ~OBImage(void);

	OBImage(const OBImage& ImageIn);
	const OBImage& operator=(const OBImage& ImageIn);
	
	void Release(void);

	/// @brief     Checks to see if the object is empty.
	///
	/// @details   This checks to see if the object is empty and returns its status.
	///
	/// @return    true if the object was empty, otherwise false.
	///
	virtual bool IsEmpty(void) const;

	/// @brief     Removes references to any resources. Makes the underlying pointer NULL.
	///
	/// @details   This will release any refernences and will deallocate any resources no longer in use. The object will not be using the
	///            empty object but will be set to NULL.
	///
	virtual void Nullify(void);

	CPData Data(void) const;

	void InitWithImageNamed(const CPString& ImageName);
	void InitWithContentsOfFile(const CPString& Path);
	void InitWithImageData(const CPData& ImageData);

	CPSize Size(void) const;
	CPSize SizeInPoints(void) const;

#ifdef __OBJC__
	OBImage(NSImage* ImageIn);
	const OBImage& operator=(NSImage* ImageIn);
	CPData m_AlternateData;
#else
	void* GDIImage(void) const;

private:
	void SetInternal(void* Internal);
#endif
};
